% jipsj.cls  (C) 2014 IPSJ
% Author: Kiminori Matsuzaki

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jipsj}
[2014/10/03 v1.00 JIPSJ class]

% Document Style
\newif\ifDS@draft \DS@draftfalse

\DeclareOption{draft}{\DS@drafttrue}
\ProcessOptions

% Load Base Class
\LoadClass[a4paper,10pt,twocolumn%
\ifDS@draft ,draft\fi
]{jarticle}

% Paper size / Text Area
\oddsidemargin=-5.4mm
\evensidemargin=\oddsidemargin
\topmargin=-5.4mm
\topsep=0pt
\headheight=0pt
\headsep=0pt
\textwidth=170mm
\textheight=257mm
\columnsep=6zw

% font size / line stretch
\renewcommand{\normalsize}{%
    \@setfontsize\normalsize\@xpt{18.65}%
  \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize

% No numbering of sections
\renewcommand{\thesection}{\hskip-1zw}
\renewcommand{\thesubsection}{\hskip-1zw}
\renewcommand{\thesubsubsection}{\hskip-1zw}
\renewcommand{\theparagraph}{\hskip-1zw}
\renewcommand{\thesubparagraph}{\hskip-1zw}

% Information of the article
% title
\def\subtitle#1{\gdef\@subtitle{#1}}\gdef\@subtitle{}
\def\etitle#1{\gdef\@etitle{#1}}\gdef\@etitle{}
% author
\def\eauthor#1{\gdef\@eauthor{#1}}\gdef\@eauthor{}
\def\jabstract#1{\gdef\@jabstract{#1}}

\def\maketitle{%
  \thispagestyle{empty}
  \setcounter{page}{0}
  \begin{picture}(0,0)
    \put(-57,-780){\includegraphics[bb=0 0 580 840]{guide.pdf}}
  \end{picture}
  \clearpage
  \maketitlenc
}
\def\maketitlenc{%
  \twocolumn[%
    \@tempdima\textwidth\advance\@tempdima-10pt
    \noindent\fbox{\hbox to \@tempdima{\vbox to 70mm{\hsize=\@tempdima\vskip1zh
          {\Huge \@title}\vskip1zh\par
          {\LARGE \@subtitle}\vskip2zh\par
          {\LARGE \@author}\par
          \vfill}}}
    \bigskip
]}

\def\authorinfo#1#2#3{%
\parindent=0zw
\smallskip\par\fbox{\hbox{\vbox{\hsize=21zw\small #1\par E-mail: #2\par #3\vfil}}}
}

\def\showInfo{%
  \clearpage
  \onecolumn
  {\LARGE etɕKvȏ}\par
  \begin{description}
  \item[e̓{^Cg] \@title
  \item[ẻp^Cg] \@etitle
  \item[Ҏij] \@author
  \item[p()] \@eauthor
  \item[AuXgNgi{300ȓAdq}ق̏Ɍfڂ܂j] ~\\ \@jabstract
  \end{description}
}

\endinput
%%
%% End of file `jipsj.cls'.
